﻿(function ($) {
    $.FroalaEditor.DefineIcon('libraryIcon', { NAME: 'star' });
    $.FroalaEditor.DefineIcon('pipingIcon', { NAME: 'magic' });
    $.FroalaEditor.DefineIcon('collapseIcon', { NAME: 'arrow-left' });

    //Colapse toolbar
    $.FroalaEditor.RegisterCommand('a4collapse', {
        title: richTextEditorResources.ImagefromLibrary,
        icon: 'collapseIcon',
        undo: false,
        focus: false,
        showOnMobile: true,
        refreshAfterCallback: true,
        callback: function () {
            var shortButtonsList = this.opts.a4_short_buttons_list;

            if (shortButtonsList && shortButtonsList.length > 0) {
                var collapseButton = this.button.getButtons("[data-cmd='a4collapse']");
                var collapseButtonIcon = $("i.fa", collapseButton);
                var collapse = collapseButtonIcon.hasClass("fa-arrow-left");

                var buttonsList = $(this.button.getButtons("*")).each(function () {
                    var button = $(this).attr("data-cmd");
                    if (button != "a4collapse" && shortButtonsList.indexOf(button) < 0)
                        $(this).toggle(!collapse);
                });

                var toolbarContainer = this.$tb.closest(".rich-text-toolbar");

                if (toolbarContainer.length > 0) {
                    var toolbarWidth = (collapse ? (shortButtonsList.length + 1) : 11) * collapseButton.width();
                    this.$tb.width(toolbarWidth);
                    toolbarContainer.css({ "top": -this.$tb.outerHeight(true) + 1 });
                }

                collapseButtonIcon.toggleClass("fa-arrow-right fa-arrow-left");
            }
        },
        refresh: function ($btn) {
        }
    });

    // Image Library
    $.FroalaEditor.RegisterCommand('a4imagefromlibrary', {
        title: richTextEditorResources.ImageFromLibrary,
        icon: 'libraryIcon',
        undo: true,
        focus: true,
        showOnMobile: true,
        callback: function () {
            var editor = this;

            editor.toolbar.hide();

            a4.getElementWindow(editor.$oel).modalDialog.showWindow(a4.getAction("MediaSelector", "Shared", "Home", { selectedItemId: 0, mediaType: 1 }), 800, 635, {
                beforeClose: function () {
                    var value = $('#v-selectedURL', modalDialog.getTopDialog()).val();

                    if (value)
                        editor.image.insert(value);

                    editor.toolbar.show();
                }
            });
        }
    });

    //Video Library
    $.FroalaEditor.RegisterCommand('a4videofromlibrary', {
        title: richTextEditorResources.VideoFromLibrary,
        icon: 'libraryIcon',
        undo: true,
        focus: true,
        showOnMobile: true,
        callback: function () {
            var editor = this;

            editor.toolbar.hide();

            a4.getElementWindow(editor.$oel).modalDialog.showWindow(a4.getAction("MediaSelector", "Shared", "Home", { selectedItemId: 0, mediaType: 2 }), 800, 635, {
                beforeClose: function () {
                    var value = $('#v-selectedURL', modalDialog.getTopDialog()).val();

                    if (value) {
                        var extension = value.split('.').pop();
                        var videoCode = '<video controls><source src="' + value + '" type="video/' + extension + '">' + richTextEditorResources.BrowserVideoSupportError + '</video>';
                        editor.html.insert(videoCode);
                    }
                }
            });
        }
    });
}(jQuery));

(function ($) {
    $.widget("a4.a4richTextEditor", {
        options: {
            fullToolbar: true,
            inline: false,
            multiLine: true,
            singleEditor: false, //Uses the same toolbar html code for all editors in the page. Needs more testing
            library: false,
            piping: false,
            piping_system: false,
            piping_distribute: false,
            piping_distribute_sms: false,
            embed_questions: false,
            short_buttons_list: ["bold", "italic", "fontFamily", "fontSize"], //Must enable a4collapse to work
            placeholderText: "",
            height: undefined,
            minHeight: undefined,
            maxHeight: undefined,
            initOnClick: undefined,
            pastePlain: false,
            pasteAllowedStyleProps: [],
        },
        _create: function () {
            var wrapper = this.element.closest(".rich-text-container");

            if (wrapper.length == 0) {
                this.element.wrap($("<div />", { "class": "rich-text-container" }));
                wrapper = this.element.closest(".rich-text-container");
            }

            this.wrapper = wrapper;

            this._bindEvents();

            this.element.addClass("rich-text-editor editable");

            this._initializeEditor();

            if (this.options.inline) {
                this.element.addClass("rich-text-editor-inline");
            }

            if (!this.options.fullToolbar) {
                this.element.addClass("text-only");
            }
        },
        _bindEvents: function () {
            var self = this;
            var inline = this.options.inline;
            var codeView = !this.options.fullToolbar;
            var initOnClick = this.options.initOnClick;

            if (typeof initOnClick == "undefined")
                initOnClick = this.options.inline && this.options.fullToolbar;

            var setInitialized = function (editor) {
                self.editor = editor;

                if (self.element.is(":disabled"))
                    editor.edit.off();

                var html = a4.decodeHtml(editor.html.get());

                if (codeView && editor.codeView) {
                    editor.codeView.toggle();
                    $('textarea.fr-code', editor.$box).val(html);
                }
                else {
                    editor.html.set(html);
                }

                if (inline && self.toolbar) {
                    self.toolbar.hide();
                }
            };

            if (initOnClick) {
                this.element.on('froalaEditor.initializationDelayed', function (e, editor) {
                    setInitialized(editor);
                });
            }

            this.element.on('froalaEditor.initialized', function (e, editor) {
                if (!initOnClick)
                    setInitialized(editor);

                self._trigger("ready", e, { editor: editor });
            });

            this.wrapper.on('blur', 'textarea.fr-code, .fr-element', function (e) {
                if (self.element.froalaEditor("events.blurActive")) {
                    if (!codeView && self.editor.codeView.isActive() && $(e.currentTarget).is(".fr-code")) {
                        self.editor.codeView.toggle();
                        $(".fr-view", self.element).trigger("blur");
                    }
                    else {
                        if (inline)
                            self.toolbar.hide();

                        self.element.removeClass("editing");

                        self._trigger("blur", e, {});
                    }
                }
            });

            this.wrapper.on('focus', 'textarea.fr-code, .fr-element', function (e) {
                if (inline) {
                    self.toolbar.show();
                    self._repositionToolbar(self.editor);
                }

                self.element.addClass("editing");

                self._trigger("focus", e, {});
            });

            this.element.on('froalaEditor.contentChanged', function (e, editor) {
                if (editor.$oel.is(":input")) {
                    editor.$oel.val(editor.html.get());
                    editor.$oel.trigger("change");
                }
                else {
                    self.element.trigger("change");
                }

                editor.$oel.attr("data-changed", "true");

                self._trigger("contentChange", e, {});
            });

            this.wrapper.on('change', 'textarea.fr-code', function (e) {
                self.element.attr("data-changed", "true");

                self._trigger("contentChange", e, {});
            });

            this.element.on('froalaEditor.html.get', function (e, editor, html) {
                if (_.isString(html) && (/(\s|<br>|<br\/>|<br \/>)+$/gi).test(html) && !(/(\s|<br>|<br\/>|<br \/>){2,}$/gi).test(html))
                    html = html.replace(/(\s|<br>|<br\/>|<br \/>)+$/gi, '');

                return html;
            });

            this.element.on('froalaEditor.keydown', function (e, editor, keydownEvent) {
                self._trigger("keydown", keydownEvent, { editor: editor });
            });

            var imageToUpload = null;
            this.element.on('froalaEditor.image.beforeUpload', function (e, editor, img) {
                if (imageToUpload == null) {
                    if (typeof img !== 'undefined' && img.length > 0 && img[0].name !== undefined) {
                        imageToUpload = img[0];
                        a4.callServerMethod(a4.getAction("VerifyFileNameIdExists", "Shared"), { "fileName": img[0].name.replace(/\.[^/.]+$/, "") },
                            function (result) {
                                if (result != 0) {
                                    hideToolbar();

                                    a4.getElementWindow(editor.$oel).modalDialog.showConfirmDialog(confirmOverwriteResources,
                                        function () {
                                            self.element.data('froala.editor').opts.imageUploadParams.overwriteExistingFile = true;
                                            self.element.froalaEditor('image.upload', [imageToUpload]);
                                            showToolbar();
                                        }, 250, 500, true, null, {
                                        cancel: function () {
                                            clearImageUploading();
                                            showToolbar();
                                        }
                                    });
                                }
                                else {
                                    self.element.froalaEditor('image.upload', [imageToUpload]);
                                }
                            });
                    }
                    hideToolbar();
                    return false;
                }
            });

            function clearImageUploading() {
                self.element.data('froala.editor').opts.imageUploadParams.overwriteExistingFile = false;
                imageToUpload = null;
            }

            function showToolbar() {
                if (inline)
                    setTimeout(function () { self.toolbar.show(); }, 600);
            }

            function hideToolbar() {
                if (inline)
                    self.toolbar.hide();
            }

            this.element.on('froalaEditor.image.uploaded', function (e, editor, response) {
                clearImageUploading();
            });

            this.element.on('froalaEditor.image.error', function (e, editor, error) {
                a4.showErrorMessage(error.message);
                clearImageUploading();
            });

            this.element.on('froalaEditor.popups.refresh.link.insert', function () {
                var link = self.editor.link.get();
                if (link) {
                    hideToolbar();
                }
            });

            this.element.on('froalaEditor.popups.hide.link.insert', showToolbar);

            if (a4.inIFrame(this.element) && inline) {
                this.element.scrollParent().on("scroll", function () {
                    self._repositionToolbar(self.editor);
                });
            }
        },
        _initializeEditor: function () {
            var opt = {};
            var plugins = [];
            var initOnClick = this.options.initOnClick;

            if (typeof initOnClick == "undefined")
                initOnClick = this.options.inline && this.options.fullToolbar;

            if (this.options.inline) {
                this.toolbar = this._getInlineToolbar();
                opt.toolbarContainer = "#" + this.toolbar.attr("id");
            }

            //Image selector options
            opt.imageEditButtons = ['imageReplace', 'imageAlign', 'imageRemove', '|', 'imageLink', 'linkOpen', 'linkEdit', 'linkRemove', '-', 'imageDisplay', 'imageAlt', 'imageSize'];
            opt.imageInsertButtons = ['imageBack', '|', 'imageByURL', 'imageUpload', 'a4imagefromlibrary'];
            opt.imageUploadURL = a4.getAction("UpdloadFileFromRichTextEditor", "Shared");
            opt.imageUploadParams = { "mediaTypeId": 1, "overwriteExistingFile": false };
            opt.imageMaxSize = 1024 * 1024 * 50;
            opt.imageDefaultDisplay = "inline";
            opt.imageDefaultWidth = 0;

            //Video selector options
            opt.videoInsertButtons = ['videoBack', '|', 'videoByURL', 'videoUpload', 'a4videofromlibrary'];
            opt.videoUploadURL = a4.getAction("UpdloadFileFromRichTextEditor", "Shared");
            opt.videoUploadParams = { "mediaTypeId": 2, "overwriteExistingFile": false };
            opt.videoMaxSize = 1024 * 1024 * 50;

            //Link options
            opt.linkConvertEmailAddress = false;
            opt.linkInsertButtons = ['linkBack'];
            opt.linkEditButtons = ['linkEdit', 'linkRemove'];

            //Table options
            opt.tableEditButtons = ['tableHeader', 'tableRemove', '|', 'tableRows', 'tableColumns', '-', 'tableCells', 'tableCellBackground', 'tableCellVerticalAlign', 'tableCellHorizontalAlign'];

            this.buttons = this._getToolbarButtons();

            if (this.options.fullToolbar)
                plugins = ['align', 'a4colors', 'draggable', 'entities', 'file', 'fontFamily', 'fontSize', 'image', 'inlineStyle', 'lineBreaker', 'lists', 'paragraphFormat', 'table', 'video', 'wordPaste', 'link'];

            if (this.options.piping)
                plugins.push('a4piping');

            plugins.push('codeView');

            //All options
            opt.key = "6A4F6E4F3bA2B6D5E2F4B2D2C3G2E2uENARBFSTb2D1QJd1RA==";
            opt.multiLine = this.options.multiLine;
            opt.toolbarButtons = this.buttons;
            opt.toolbarButtonsMD = this.buttons;
            opt.toolbarButtonsSM = this.buttons;
            opt.toolbarButtonsXS = this.buttons;
            opt.pluginsEnabled = plugins
            opt.toolbarSticky = true;
            opt.placeholderText = this.options.placeholderText;
            opt.theme = 'custom';
            opt.charCounterCount = false;
            opt.htmlUntouched = true;
            opt.htmlAllowedTags = ['.*'];            
            opt.htmlAllowedAttrs = !a4.isJsDomEventsAllowed ? ['^(?!on).*'] : ['.*']; // When DOM events not allowed, block the HTML event attributes 
            opt.htmlAllowedEmptyTags = ['*'];
            opt.htmlRemoveTags = [];
            opt.language = $("html").attr("lang");
            opt.editInPopup = false;
            opt.enter = $.FroalaEditor.ENTER_BR;
            opt.tooltips = false; //Grid editors bug - Inside fancy box. Check better solution
            opt.spellcheck = false;
            opt.tabSpaces = 0;
            opt.height = this.options.height;
            opt.heightMin = this.options.minHeight; //this.element.height()
            opt.heightMax = this.options.maxHeight;
            opt.initOnClick = initOnClick;
            opt.entities = '&lt;&gt;&amp;'; //For escaping < > & only            
            opt.codeViewKeepActiveButtons = ["piping", "embed"];
            opt.htmlExecuteScripts = false;
            opt.pastePlain = this.options.pastePlain;
            opt.pasteAllowedStyleProps = this.options.pasteAllowedStyleProps;

            //Custom options
            opt.pipingSurvey = this.options.piping;
            opt.pipingSystem = this.options.piping_system;
            opt.pipingDistribute = this.options.piping_distribute;
            opt.pipingDistributeSms = this.options.piping_distribute_sms;
            opt.embedQuestions = this.options.embed_questions;

            if (this.options.short_buttons_list && this.options.short_buttons_list.length > 0) {
                opt.a4_short_buttons_list = this.options.short_buttons_list;
            }

            if (this.options.fullPage) {
                opt.fullPage = true;
            }

            this.element.froalaEditor(opt);
        },
        _getToolbarButtons: function () {
            var buttons = [];

            if (this.options.fullToolbar) {
                buttons = ['bold', 'italic', 'underline', 'fontFamily', 'fontSize', 'color', 'paragraphFormat', 'align', 'formatOL', 'formatUL', 'outdent', 'indent', 'insertHR', 'insertLink', 'insertTable', 'undo', 'redo', 'clearFormatting'];
            }

            if (this.options.piping || this.options.piping_system || this.options.piping_distribute) {
                buttons.push('piping');
            }

            if (this.options.embed_questions) {
                buttons.push('embed');
            }

            if (this.options.library) {
                buttons.push('insertImage');
                buttons.push('insertVideo');
            }

            if (this.options.fullToolbar) {
                buttons.push('html');
            }

            return buttons;
        },
        _getInlineToolbar: function () {
            var toolbarId;

            if (this.options.singleEditor) {
                toolbarId = "richtexttb_single";
            }
            else {
                toolbarId = _.uniqueId("richtexttb_");
            }

            var toolbar = $("#" + toolbarId);

            if (toolbar.length == 0) {
                $("body").append($("<div />", { "class": "rich-text-toolbar", "id": toolbarId }));
                toolbar = $("#" + toolbarId);
            }

            this.toolbarId = toolbarId;

            return toolbar;
        },
        _repositionToolbar: function (editor) {
            var topA = 0;
            var leftA = 0;

            if (editor.$tb) {
                if (a4.inIFrame(this.element) && !a4.inIFrame(this.toolbar)) {
                    var parentWindow = a4.parent(this.element);
                    var fancyBoxWrap = $(".fancybox-wrap", parentWindow.document);

                    if (fancyBoxWrap.length > 0) {
                        var wrapOffset = fancyBoxWrap.offset();
                        topA = wrapOffset.top;
                        leftA = wrapOffset.left;
                    }
                }

                editor.$tb.width(Math.min(this.buttons.length, 11) * 38);

                var offset = this.element.offset();
                var top = offset.top - editor.$tb.outerHeight(true) + 1 + topA;
                var left = offset.left + leftA;

                this.toolbar.offset({ top: Math.round(top), left: Math.round(left) });

                //$(this.toolbar).position({ my: "left bottom", at: "left top", of: $(this.element) })
            }
        },
        setContent: function (content) {
            if (!this.editor)
                this.element.html(content);
            else {
                this.element.froalaEditor("html.set", content);
                if (this.editor.$iframe) {
                    const iframe = this.editor.$iframe.get(0);
                    if (iframe) {
                        const iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
                        iframeDoc.body.style.overflow = 'auto';
                    }
                }
            }

            if (this.editor.codeView && this.editor.codeView.isActive())
                $('textarea.fr-code', this.element).html(content);

            this.element.attr("data-changed", "true");
        },
        getContent: function () {
            var html;
            if (!this.editor)
                html = this.element.html();
            else if (this.editor.codeView && this.editor.codeView.isActive())
                html = this.element.froalaEditor("codeView.get");
            else
                html = this.element.froalaEditor("html.get");
            return a4.encodeHtml(html);
        },
        disable: function () {
            if (this.editor.codeView && this.editor.codeView.isActive())
                this.editor.codeView.toggle();

            this.element.prop("disabled", true);

            this.element.froalaEditor("edit.off");

        },
        enable: function () {
            this.element.prop("disabled", false);

            if (this.editor)
                this.element.froalaEditor("edit.on");
        },
        destroy: function () {
            if (this.editor) {
                if (this.editor.html) {
                    // Encode HTML to avoid XSS on froalaEditor destroy
                    var html = a4.encodeHtml(this.editor.html.get());
                    this.editor.html.set(html);
                }

                this.element.froalaEditor("destroy");
            }

            $(this.element).removeClass("rich-text-editor rich-text-editor-inline");

            $("#" + this.toolbarId).remove();

            $.Widget.prototype.destroy.call(this);
        }
    });
}(jQuery));